<?php
/* --------------------------------------------------------------
  ReadService.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Service;

use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanCollectionDto;
use Gambio\Shop\Attributes\SellingUnitEan\Repository\RepositoryInterface;
use Gambio\Shop\Product\ValueObjects\ProductId;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;

/**
 * Class ReadService
 * @package Gambio\Shop\Attributes\SellingUnitEan\Service
 */
class ReadService implements ReadServiceInterface
{
    /**
     * @var RepositoryInterface
     */
    protected $repository;
    
    
    /**
     * ReadService constructor.
     *
     * @param RepositoryInterface $repository
     */
    public function __construct(RepositoryInterface $repository)
    {
        $this->repository = $repository;
    }
    
    /**
     * @inheritDoc
     */
    public function getAttributesEanValuesByProduct(
        ProductId $productId,
        ModifierIdentifierCollectionInterface $modifiers
    ) : EanCollectionDto {
        $modifierIds = [];
        foreach ($modifiers as $modifier) {
            if ($modifier instanceof AttributeModifierIdentifier) {
                $modifierIds[] = $modifier->value();
            }
        }
        return $this->repository->getEanValuesByProduct($modifierIds, $productId);
    }
}